// js页面跳转
function change_status_url(obj, url, active_class = 'active') {
    if($(obj).hasClass(active_class)) return false;
    window.location.href = url;
}

/**
 * 操作ajax
 * @param url
 * @param data
 * @param obj 当前jq对象
 * @param okCode 成功固定代码
 * @param action_type 0刷新页面，1移除当前行
 */
var doAjax = function(url, data= {}, obj, okCode = 1, action_type = 0) {
    $.ajax({
        url: url,
        type: 'POST',
        data: data,
        beforeSend: function() {
            layer.load(2, {time: 0});
        },
        success: function(res) {
            layer.closeAll();
            if (res.code === okCode) {
                layer.msg(res.msg, { icon: 1, time: 1200}, function () {
                    switch (action_type) {
                        default:
                            window.location.reload();
                    }
                });
            } else {
                layer.msg(res.msg, { icon: 2});
            }
        },
        error: function() {
            layer.closeAll();
            layer.msg('服务器繁忙，请稍后再试！', {icon: 2});
        }
    });
}

$(function () {
    // alert 提示
    $('body').on('click', '[data-alert]', function () {
        layer.alert($(this).data('alert'), { icon: 6, title: '温馨提示' });
    })
    $('body').on('click', '[data-alert-html]', function () {
        var that = $(this);
        layer.open({
            type: 1,
            shade: false,
            title: '温馨提示',
            content: that.data('alert-html')
        });
    })
    // 模态框
    $('body').on('click', '[data-modal]', function () {
        var openUrl = $(this).data('modal');
        var openTitle = $(this).attr('title');
        var size = $(this).data('size');
        if(!size) {
            size = ['700px', '500px']
        } else {
            var sizeArr = size.split(',');
            size = [sizeArr[0], sizeArr[1]]
        }
        layer.open({
            type: 2,
            shadeClose: true,
            shade: 0.1,
            title: openTitle,
            area: size,
            content: openUrl
        });
    })
    $('body').on('click', '[data-form]', function () {
        var openObj = $($(this).data('form'));
        var openTitle = $(this).attr('title');
        var size = $(this).data('size');
        if(!size) {
            size = ['700px', '500px']
        } else {
            var sizeArr = size.split(',');
            size = [sizeArr[0], sizeArr[1]]
        }
        var index = layer.open({
            type: 1,
            shadeClose: true,
            shade: 0.1,
            title: openTitle,
            area: size,
            content: openObj
        });
        layer_index.push(index);
    })
    $('body').on('click', '[data-action]', function () {
        var confirm_msg = $(this).data('confirm');
        var url = $(this).data('action');
        var info = $(this).data('info');
        var okCode = parseInt($(this).data('ok'));
        var action_type = parseInt($(this).data('type'));
        if(isNaN(okCode)) okCode = 1;
        if(isNaN(action_type)) action_type = 0;
        var obj = $(this);
        var sendData = {};
        if(info) {
            sendData = info;
        }
        if(confirm_msg) {
            layer.confirm(confirm_msg, {title:'操作提醒', icon: 3}, function () {
                doAjax(url, sendData, obj, okCode, action_type)
            });
        } else {
            doAjax(url, sendData, obj, okCode, action_type)
        }
    })
    $('body').on('click', '[data-save-form]', function () {
        var url = $(this).parents('form').attr('action');
        var method = $(this).parents('form').attr('method');
        var scene = $(this).data('scene');
        var sendData = {};
        sendData = $(this).parents('form').serialize();
        var loading;
        do_ajax(url, sendData, function () {
            loading = layer.load(2, {time: 0})
        }, function (res) {
            layer.close(loading);
            if (res.code === 1) {
                switch (scene) {
                    case 'add_cate':
                        layer.msg('分类添加成', {icon: 1, time: 1200}, function () {
                            var category_name = $('#add_cate input[name="name"]').val();
                            var cate_id = res.msg;
                            $('[name="cate_id"]').prepend("<option value='" + cate_id + "' selected>" + category_name + "</option>");
                            layer.close(layer_index[layer_index.length-1]);
                        });
                        break;
                    default:
                        layer.msg(res.msg, {icon: 1, time: 1200}, function () {});
                }
            } else {
                layer.msg(res.msg, {icon: 5});
            }
        }, null, method)
    })
})